<?php

namespace App\Jobs;

use App\Transaction;
use App\Contact;
use App\Utils\NotificationUtil;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendBusinessNotification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $business_id;
    public string $template;
    public int $transaction_id;
    public ?int $contact_id;

    public function __construct(int $business_id, string $template, int $transaction_id, ?int $contact_id)
    {
        $this->business_id = $business_id;
        $this->template = $template;
        $this->transaction_id = $transaction_id;
        $this->contact_id = $contact_id;
    }

    public function handle(NotificationUtil $notificationUtil): void
    {
        $transaction = Transaction::find($this->transaction_id);
        $contact = $this->contact_id ? Contact::find($this->contact_id) : null;
        if ($transaction) {
            $notificationUtil->autoSendNotification($this->business_id, $this->template, $transaction, $contact);
        }
    }
}

